// To parse this JSON data, do
//
//     final recentRequestResponseModel = recentRequestResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:play_lab/data/model/global/global_meassage.dart';

RecentRequestResponseModel recentRequestResponseModelFromJson(String str) => RecentRequestResponseModel.fromJson(json.decode(str));

String recentRequestResponseModelToJson(RecentRequestResponseModel data) => json.encode(data.toJson());

class RecentRequestResponseModel {
  String? remark;
  String? status;
  Message? message;
  Data? data;

  RecentRequestResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory RecentRequestResponseModel.fromJson(Map<String, dynamic> json) => RecentRequestResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  List<RecentItem>? items;

  Data({
    this.items,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        items: json["items"] == null ? [] : List<RecentItem>.from(json["items"]!.map((x) => RecentItem.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "items": items == null ? [] : List<dynamic>.from(items!.map((x) => x.toJson())),
      };
}

class RecentItem {
  String? id;
  String? categoryId;
  String? subCategoryId;
  String? slug;
  String? title;
  String? previewText;
  String? description;
  Team? team;
  Image? image;
  String? itemType;
  String? status;
  String? single;
  String? trending;
  String? featured;
  String? version;
  String? tags;
  String? ratings;
  String? view;
  String? isTrailer;
  String? rentPrice;
  String? rentalPeriod;
  String? excludePlan;
  String? seoContent;
  String? createdAt;
  String? updatedAt;

  RecentItem({
    this.id,
    this.categoryId,
    this.subCategoryId,
    this.slug,
    this.title,
    this.previewText,
    this.description,
    this.team,
    this.image,
    this.itemType,
    this.status,
    this.single,
    this.trending,
    this.featured,
    this.version,
    this.tags,
    this.ratings,
    this.view,
    this.isTrailer,
    this.rentPrice,
    this.rentalPeriod,
    this.excludePlan,
    this.seoContent,
    this.createdAt,
    this.updatedAt,
  });

  factory RecentItem.fromJson(Map<String, dynamic> json) => RecentItem(
        id: json["id"]?.toString(),
        categoryId: json["category_id"]?.toString(),
        subCategoryId: json["sub_category_id"]?.toString(),
        slug: json["slug"]?.toString(),
        title: json["title"]?.toString(),
        previewText: json["preview_text"]?.toString(),
        description: json["description"]?.toString(),
        team: json["team"] == null ? null : Team.fromJson(json["team"]),
        image: json["image"] == null ? null : Image.fromJson(json["image"]),
        itemType: json["item_type"]?.toString(),
        status: json["status"]?.toString(),
        single: json["single"]?.toString(),
        trending: json["trending"]?.toString(),
        featured: json["featured"]?.toString(),
        version: json["version"]?.toString(),
        tags: json["tags"]?.toString(),
        ratings: json["ratings"]?.toString(),
        view: json["view"]?.toString(),
        isTrailer: json["is_trailer"]?.toString(),
        rentPrice: json["rent_price"]?.toString(),
        rentalPeriod: json["rental_period"]?.toString(),
        excludePlan: json["exclude_plan"]?.toString(),
        seoContent: json["seo_content"]?.toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "category_id": categoryId,
        "sub_category_id": subCategoryId,
        "slug": slug,
        "title": title,
        "preview_text": previewText,
        "description": description,
        "team": team?.toJson(),
        "image": image?.toJson(),
        "item_type": itemType,
        "status": status,
        "single": single,
        "trending": trending,
        "featured": featured,
        "version": version,
        "tags": tags,
        "ratings": ratings,
        "view": view,
        "is_trailer": isTrailer,
        "rent_price": rentPrice,
        "rental_period": rentalPeriod,
        "exclude_plan": excludePlan,
        "seo_content": seoContent,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class Image {
  String? landscape;
  String? portrait;

  Image({
    this.landscape,
    this.portrait,
  });

  factory Image.fromJson(Map<String, dynamic> json) => Image(
        landscape: json["landscape"],
        portrait: json["portrait"],
      );

  Map<String, dynamic> toJson() => {
        "landscape": landscape,
        "portrait": portrait,
      };
}

class Team {
  String? director;
  String? producer;
  String? casts;
  String? genres;
  String? language;

  Team({
    this.director,
    this.producer,
    this.casts,
    this.genres,
    this.language,
  });

  factory Team.fromJson(Map<String, dynamic> json) => Team(
        director: json["director"].toString(),
        producer: json["producer"].toString(),
        casts: json["casts"].toString(),
        genres: json["genres"].toString(),
        language: json["language"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "director": director,
        "producer": producer,
        "casts": casts,
        "genres": genres,
        "language": language,
      };
}
